﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using BMS.Facade.Data;
using BMS.ServicesWrapper.BMService;
using BMS.Facade.Translators;
using InfoWorld.HL7.ITS;
using BMS.Utils;
using InfoWorld.EVS.CTSMAPI;
using BMS.ServicesWrapper.EVS;
using BMS.ServicesWrapper.WF;
using BMS.VistaWorker2.Writer.Exceptions;
using BMS.Facade;


namespace BMS.VistaWorker2.Writer.Implementation.Concrete.EIS
{
    public class BedUnavailableWriter
    {
        public static IEVSWrapper EVS { get { return EVSFactory.InstanceWindows; } }

        public BedUnavailableWriter() { }

        public bool GetBedUnavailableHasChanged(CommonData data, RoomBed vistaEntity, Bed bmsEntity)
        {
            BMS.DataContracts.BedUnavailableInfo bedUnavailableInfo = data.BedUnavailableDal.Get(bmsEntity.Id);
            if (vistaEntity.CurrentlyOutOfService)
            {
                if (bedUnavailableInfo == null)
                    return true;
                if (!bedUnavailableInfo.IsUnavailableFromVistA)
                    return true;
            }
            else
            {
                if (bedUnavailableInfo != null && bedUnavailableInfo.IsUnavailableFromVistA)
                    return true;
            }
            return false;
        }

        public void ChangeBedUnavailable(CommonData data, RoomBed vistaEntity, Bed bmsEntity)
        {
            BedUnavailable bedUnavailable = null;
            try
            {
                bedUnavailable = BMSFactory.BedManagerOperationsClientWindows.GetBedUnavailable(null, bmsEntity.Id).ToFacadeContract();
            }
            catch (System.ServiceModel.FaultException<FaultContracts.EntityNotFoundException>)
            {
                bedUnavailable = null;
            }
            catch (Exception ex)
            {
                Tracer.TraceMessage("Exception on GetBedUnavailable from BMS for bed: " + bmsEntity.Id.extension);
                Tracer.TraceException(ex);
                throw;
            }
            if (vistaEntity.CurrentlyOutOfService)
            {
                if (bedUnavailable == null)
                    CreateBedUnavailable(data, bmsEntity);
                else
                    if (!bedUnavailable.OutOfServiceVistA)
                        UpdateBedUnavailable(data, vistaEntity, bmsEntity, bedUnavailable);
            }
            else
            {
                if (bedUnavailable != null && bedUnavailable.OutOfServiceVistA)
                    CancelBedUnavailable(data, vistaEntity, bmsEntity, bedUnavailable);
            }
        }

        private void CancelBedUnavailable(CommonData data, RoomBed vistaEntity, Bed bmsEntity, BedUnavailable bedUnavailable)
        {
            bedUnavailable.Bed.Name = bmsEntity.Name;
            bedUnavailable.CanceledBy = string.Empty;
            bedUnavailable.CanceledDate = DateTime.UtcNow;
            bedUnavailable.OutOfServiceVistA = true;
            bedUnavailable.WardList = bmsEntity.WardList;
            WFFactory.BedUnavailableWorkflowClientWindows.CancelBedUnavailable(bedUnavailable);
            data.Logger.LogFormat(BmsLogger.Level.Info, "Cancel bed unavailable for bed {0}", bmsEntity.Name);            
        }

        private void UpdateBedUnavailable(CommonData data, RoomBed vistaEntity, Bed bmsEntity, BedUnavailable bedUnavailable)
        {
            CDWithProperties reason = GetOutofServiceReason();
            string typeCode = reason.Properties.Where(a => a.PropertyName.text == "Type").FirstOrDefault().PropertyValue.text;
            IList<CD> typeIList = null;
            typeIList = EVS.GetCodes(new CodeFilterParameters() { MaxSelectedCodes = int.MaxValue, VocabularyDomain = Util.Vocabulary.AdminURType.ToString() });
            List<CD> typeList = new List<CD>();
            if (typeIList != null && typeIList.Count >= 0) {
                typeList = typeIList.ToList();
                //typeList.AddRange(typeIList);
            }
            bedUnavailable.Bed.Name = bmsEntity.Name;
            bedUnavailable.OutOfServiceVistA = true;
            bedUnavailable.CreationDate = DateTime.UtcNow;
            bedUnavailable.WardList = bmsEntity.WardList;
            bedUnavailable.Reason = new CD(reason.code, reason.codeSystem, reason.codeSystemName, null, reason.displayName, null, null, null);
            bedUnavailable.Type = typeList.Where(a => a.code == typeCode).FirstOrDefault();
            WFFactory.BedUnavailableWorkflowClientWindows.UpdateBedUnavailable(bedUnavailable);
            data.Logger.LogFormat(BmsLogger.Level.Info, "Update bed unavailable for bed {0}", bmsEntity.Name);            
        }

        private CDWithProperties GetOutofServiceReason()
        {
            CodeFilterParametersWithProperty codeFilterParamWithProperties = new CodeFilterParametersWithProperty();
            codeFilterParamWithProperties.MaxSelectedCodes = int.MaxValue;
            codeFilterParamWithProperties.VocabularyDomain = Util.Vocabulary.UnavailableReason.ToString();
            codeFilterParamWithProperties.Properties = new List<string>();
            codeFilterParamWithProperties.Properties.Add("Type");
            List<CDWithProperties> reasonList = EVS.GetCodesWithProperties(codeFilterParamWithProperties).ToList();
            CDWithProperties reason = reasonList.Where(a => a.Properties.Where(b => b.PropertyName.text == "Type").FirstOrDefault().PropertyValue.text == Constants.BED_OUT_OF_SERVICE_TYPE_CODE
                                                       && a.code.Equals(Constants.NATIONAL_BED_OUT_OF_SERVICE_CODE)).FirstOrDefault();
            if (reason == null)
                reason = reasonList.Where(a => a.Properties.Where(b => b.PropertyName.text == "Type").FirstOrDefault().PropertyValue.text == Constants.BED_OUT_OF_SERVICE_TYPE_CODE
                                            && a.code.StartsWith(Constants.NATIONAL_VOCABULARY_CODE_PREFIX)).FirstOrDefault();

            if (reason == null)
                throw new InvalidOperationException("Cannot create unavailable bed because vista doesn't have an associated bed out of service reason.");
            
            return reason;
        }

        private void CreateBedUnavailable(CommonData data, Bed bmsEntity)
        {           
            CDWithProperties reason = GetOutofServiceReason();
            string typeCode = reason.Properties.Where(a => a.PropertyName.text == "Type").FirstOrDefault().PropertyValue.text;
            string domainId = BMS.ServicesWrapper.Security.SecurityFactory.InstanceWindows.GetCurrentDomain();
            IList<CD> typeIList = EVS.GetCodes(new CodeFilterParameters() { MaxSelectedCodes = int.MaxValue, VocabularyDomain = Util.Vocabulary.AdminURType.ToString() });
            List<CD> typeList = new List<CD>();
            if (typeIList != null && typeIList.Count >= 0) {
                typeList = typeIList.ToList();
                //typeList.AddRange(typeIList);
            }

            BedUnavailable bedUnavailable = new BedUnavailable()
            {
                Bed = (bmsEntity != null) ? new Place() { Id = bmsEntity.Id, Name = bmsEntity.Name } : null,
                CanceledBy = null,
                CanceledDate = null,
                CreatedBy = string.Empty,
                CreationDate = DateTime.UtcNow,
                EditedBy = null,
                EditedDate = null,
                Id = new II(domainId, null),
                Parent = null,
                Patient = null,
                Reason = new CD(reason.code, reason.codeSystem, reason.codeSystemName, null, reason.displayName, null, null, null),
                Type = typeList.Where(a => a.code == typeCode).FirstOrDefault(),
                OutOfServiceVistA = true,
                VistaSite = data.Site,
                WardList = bmsEntity.WardList
            };
            WFFactory.BedUnavailableWorkflowClientWindows.CreateBedUnavailable(bedUnavailable);
            data.Logger.LogFormat(BmsLogger.Level.Info, "Create bed unavailable for bed {0}", bmsEntity.Name);            
        }
    }
}
